from .shared import db

class MoneyRequest(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    title = db.Column(db.String(80), nullable=False)
    description = db.Column(db.String(120), nullable=False)
    amount = db.Column(db.Integer)

    sender = db.Column(db.String(80), db.ForeignKey('user.username'), nullable=False)
    recipient = db.Column(db.String(80), db.ForeignKey('user.username'), nullable=False)

    def __repr__(self):
        return '<MoneyRequest %r>' % self.id